% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{multipleFilterResult-class}
\alias{multipleFilterResult-class}
\alias{multipleFilterResult}
\alias{length,multipleFilterResult-method}
\alias{names,multipleFilterResult-method}
\alias{names<-,multipleFilterResult-method}
\alias{names<-,multipleFilterResult,ANY-method}
\alias{[[,multipleFilterResult-method}
\alias{[[,multipleFilterResult,ANY-method}
\alias{[,multipleFilterResult,ANY-method}
\alias{summary,multipleFilterResult-method}
\alias{show,multipleFilterResult-method}
\title{Class "multipleFilterResult"}
\description{
Container to store the result of applying \code{filter} on set of
\code{flowFrame} objects
}
\section{Slots}{

\describe{
\item{\code{subSet}}{Object of class \code{"factor"} indicating the population
membership of the data in the gated flowFrame.}

\item{\code{frameId}}{Object of class \code{"character"}
referencing the \code{flowFrame} object filtered. Used for
sanity checking.}

\item{\code{filterDetails}}{Object of class \code{"list"}
describing the filter applied.}

\item{\code{filterId}}{Object of class \code{"character"}
referencing the filter applied.}
}}

\section{Extends}{


Class \code{"\linkS4class{filterResult}"}, directly.
Class \code{"\linkS4class{filter}"}, by class "filterResult", distance 2.
}

\section{Methods}{


\describe{
  \item{[, [[}{subsetting. If \code{x} is \code{multipleFilterResult},
    then \code{x[[i]]} a \code{FilterResult}  object. The semantics is
    similar to the behavior of the subsetting operators for lists.}
  \item{length}{number of \code{FilterResult} objects in the set.}
  \item{names}{names of the  \code{FilterResult} objects in the set.}
  \item{summary}{summary \code{FilterResult} objects in the set.}
}
}

\examples{

showClass("multipleFilterResult")

}
\seealso{
\code{\link[flowCore:filterResult-class]{filterResult}}
}
\author{
B. Ellis
}
\keyword{classes}
