% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_gate-methods.R
\name{rotate_gate}
\alias{rotate_gate}
\alias{rotate_gate.default}
\title{Simplified geometric rotation of gates}
\usage{
\method{rotate_gate}{default}(obj, deg = NULL, rot_center = NULL, ...)
}
\arguments{
\item{obj}{An \code{\linkS4class{ellipsoidGate}} or \code{\linkS4class{polygonGate}}}

\item{deg}{An angle in degrees by which the gate should be rotated in the counter-clockwise direction}

\item{rot_center}{A separate 2-dimensional center of rotation for the gate, if desired. By default, this will
be the center for \code{ellipsoidGate} objects or the centroid for \code{polygonGate} objects. The \code{rot_center} argument 
is currently only supported for \code{polygonGate} objects.}

\item{\dots}{Additional arguments not used}
}
\value{
A Gate-type \code{filter} object of the same type as \code{gate}, with the rotation applied
}
\description{
Rotate a Gate-type filter object through a specified angle
}
\details{
This method allows for 2-dimensional geometric rotation of filter types defined by simple geometric gates 
(\code{\linkS4class{ellipsoidGate}}, and \code{\linkS4class{polygonGate}}). The method is not defined 
for \code{rectangleGate} or \code{quadGate} objects, due to their definition as having 1-dimensional boundaries.
Further, keep in mind that the 2-dimensional rotation takes place in the plane where the dimensions
of the two variables are evenly linearly scaled. Displaying a rotated ellipse in a plot where the axes are not scaled
evenly may make it appear that the ellipse has been distorted even though this is not the case. 

The angle provided in the \code{deg} argument should be in degrees rather than radians. By default, the rotation
will be performed around the center of an \code{ellipsoidGate} or the centroid of the area encompassed by
a \code{polygonGate}. The \code{rot_center} argument allows for specification of a different center of rotation
for \code{polygonGate} objects (it is not yet implemented for \code{ellipsoidGate} objects) but
it is usually simpler to perform a rotation and a translation individually than to manually specify 
the composition as a rotation around a shifted center.
}
\examples{
\dontrun{
#' # Rotates the original gate 15 degrees counter-clockwise
rotated_gate <- rotate_gate(original_gate, deg = 15)
# Rotates the original gate 270 degrees counter-clockwise
rotated_gate <- rotate_gate(original_gate, 270)
}

}
