% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlowHist.R
\name{updateFlowHist}
\alias{updateFlowHist}
\title{updateFlowHist}
\usage{
updateFlowHist(
  fh,
  linearity = NULL,
  debris = NULL,
  samples = NULL,
  analyze = TRUE
)
}
\arguments{
\item{fh}{a \code{\link{FlowHist}} object}

\item{linearity}{character, either "variable", the default, or "fixed".
If "fixed", linearity is fixed at 2; if "variable", linearity is fit
as a model parameter.}

\item{debris}{character, either "SC", the default, or "MC", to set the
debris model component to the Single-Cut or Multi-Cut models.}

\item{samples}{integer, the number of samples in the data}

\item{analyze}{logical, if TRUE the updated model will be analyzed
immediately}
}
\value{
a \code{\link{FlowHist}} object with the modified values of
  linearity and/or debris, and, if \code{analyze} was TRUE, a new NLS
  fitting
}
\description{
Update, and optionally re-analyze, a \code{\link{FlowHist}} object
}
\details{
Allows users to switch the debris model from Single-Cut to Multi-Cut (or
  vice-versa), or to toggle linearity between fixed and variable.
}
\examples{
## defaults to 256 bins:
library(flowPloidyData) 
fh1 <- FlowHist(file = flowPloidyFiles()[1], channel = "FL3.INT.LIN")
## default is Single-Cut, change that to Multi-Cut:
fh1mc <- updateFlowHist(fh1, debris = "MC")
plot(fh1)
}
\author{
Tyler Smith
}
