% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingSet_Methods.R
\name{swap_data_cols}
\alias{swap_data_cols}
\title{Swap the colnames
Perform some validity checks before returning the updated colnames}
\usage{
swap_data_cols(cols, swap_cols)
}
\arguments{
\item{cols}{the original colname vector}

\item{swap_cols}{a named list specifying the pairs to be swapped}
}
\value{
the new colname vector that has some colnames swapped
}
\description{
Swap the colnames
Perform some validity checks before returning the updated colnames
}
\examples{
library(flowCore)
data(GvHD)
fr <- GvHD[[1]]
colnames(fr)
new <- swap_data_cols(colnames(fr), list(`FSC-H` = "SSC-H", `FL2-H` = "FL2-A"))
colnames(fr) <- new
}
