% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleSet.R
\docType{class}
\name{SampleSet-class}
\alias{SampleSet-class}
\title{S4 class object SampleSet}
\value{
a S4 object of class SampleSet
}
\description{
SampleSet is an S4 class defined for the purpose of running the
funtooNorm algorithm. They are lists containing signal data and different
variables useful for funtooNorm. The data is separated into the 3 probes
types, each having 2 channels (methylated and unmethylated ie : A and B)
We then define then the 6 (2*3) labels: AIGrn BIGrn AIRed BIRed AII BII
}
\section{Slots}{

\describe{
\item{\code{type}}{Character: is 'minfi' or 'GenomeStudio'}

\item{\code{sampleNames}}{character vector:
contain the list of sample names in order used}

\item{\code{sampleSize}}{numeric: the number of samples}

\item{\code{nPos}}{numeric: the number of positions in the ILLUMINA chip}

\item{\code{annotation}}{character: the annotation object from
minfi package}

\item{\code{cell_type}}{factor: vector of the cell type for each sample as factors}

\item{\code{qntllist}}{numeric: vector of ordered quantiles}

\item{\code{quantiles}}{list: list of  6 quantiles tables for the 6 signal types}

\item{\code{ctl.covmat}}{matrix: covariance matrix for the model fit}

\item{\code{signal}}{list: list of the values for all 6 probe types.}

\item{\code{names}}{list: list of probes for each type}

\item{\code{predmat}}{list: list of the normalized values for all 6 probe types.}
}}

\examples{
showClass("SampleSet")
}
