% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_mae_se_assay_to_dt.R
\name{convert_mae_assay_to_dt}
\alias{convert_mae_assay_to_dt}
\title{Convert a MultiAssayExperiment assay to a long data.table}
\usage{
convert_mae_assay_to_dt(
  mae,
  assay_name,
  experiment_name = NULL,
  include_metadata = TRUE,
  retain_nested_rownames = FALSE,
  wide_structure = FALSE,
  drop_masked = TRUE,
  merge_additional_variables = FALSE
)
}
\arguments{
\item{mae}{A \linkS4class{MultiAssayExperiment} object holding experiments with
raw and/or processed dose-response data in its assays.}

\item{assay_name}{String of name of the assay to transform within an experiment of the \code{mae}.}

\item{experiment_name}{String of name of the experiment in \code{mae} whose \code{assay_name} should be converted.
Defaults to \code{NULL} to indicate to convert assay in all experiments into one data.table object.}

\item{include_metadata}{Boolean indicating whether or not to include \code{rowData()}
and \code{colData()} in the returned data.table.
Defaults to \code{TRUE}.}

\item{retain_nested_rownames}{Boolean indicating whether or not to retain the rownames
nested within a \code{BumpyMatrix} assay.
Defaults to \code{FALSE}.
If the \code{assay_name} is not of the \code{BumpyMatrix} class, this argument's value is ignored.
If \code{TRUE}, the resulting column in the data.table will be named as \code{"<assay_name>_rownames"}.}

\item{wide_structure}{Boolean indicating whether or not to transform data.table into wide format.
\code{wide_structure = TRUE} requires \code{retain_nested_rownames = TRUE} however that will be validated
in \code{convert_se_assay_to_dt} function}

\item{drop_masked}{Boolean indicating whether to drop masked values; TRUE by default.}

\item{merge_additional_variables}{Boolean indicating whether to merge additional variables identified by
\code{get_additional_variables} into the \code{DrugName} column. Defaults to \code{FALSE}.}
}
\value{
data.table representation of the data in \code{assay_name}.
}
\description{
Convert an assay within a \linkS4class{SummarizedExperiment} object in a MultiAssayExperiment
to a long data.table.
}
\details{
NOTE: to extract information about 'Control' data, simply call the
function with the name of the assay holding data on controls.
}
\examples{
mae <- get_synthetic_data("finalMAE_small")
convert_mae_assay_to_dt(mae, "Metrics")

}
\seealso{
flatten convert_se_assay_to_dt
}
\author{
Bartosz Czech \href{mailto:bartosz.czech@contractors.roche.com}{bartosz.czech@contractors.roche.com}
}
\keyword{convert}
