% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_convert.R
\name{convert_metadata_to_json}
\alias{convert_metadata_to_json}
\title{Convert experiment metadata to JSON format for elasticsearch indexing.}
\usage{
convert_metadata_to_json(se)
}
\arguments{
\item{se}{SummarizedExperiment object.}
}
\value{
JSON string capturing experiment metadata.
}
\description{
Convert experiment metadata to JSON format for elasticsearch indexing.
}
\examples{
md <- list(title = "my awesome experiment",
  description = "description of experiment",
  sources = list(list(name = "GeneData_Screener", id = "QCS-12345")))
se <- SummarizedExperiment::SummarizedExperiment(metadata = md)
convert_metadata_to_json(se)

}
\keyword{json_convert}
