% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{map_conc_to_standardized_conc}
\alias{map_conc_to_standardized_conc}
\title{Create a mapping of concentrations to standardized concentrations.}
\usage{
map_conc_to_standardized_conc(conc1, conc2)
}
\arguments{
\item{conc1}{numeric vector of the concentrations for drug 1.}

\item{conc2}{numeric vector of the concentrations for drug 2.}
}
\value{
data.table of 2 columns named \code{"concs"} and \code{"rconcs"}
containing the original concentrations and their closest matched
standardized concentrations respectively. and their new standardized
concentrations.
}
\description{
Create a mapping of concentrations to standardized concentrations.
}
\details{
The concentrations are standardized in that they will contain
regularly spaced dilutions and close values will be rounded.
}
\examples{

ratio <- 0.5
conc1 <- c(0, 10 ^ (seq(-3, 1, ratio)))

shorter_range <- conc1[-1]
noise <- runif(length(shorter_range), 1e-12, 1e-11)
conc2 <- shorter_range + noise

map_conc_to_standardized_conc(conc1, conc2)

}
\keyword{package_utils}
