% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_SE.R
\name{merge_MAE}
\alias{merge_MAE}
\title{Merge multiple MultiAssayExperiment objects}
\usage{
merge_MAE(
  MAElist,
  additional_col_name = "data_source",
  discard_keys = c("normalization_type", "fit_source", "record_id", "isDay0", "swap_sa",
    "control_type", "iso_level", "conc_1", "conc_2")
)
}
\arguments{
\item{MAElist}{Named list of MultiAssayExperiment objects.}

\item{additional_col_name}{String with the name of the column that will be
added to assay data for the distinction of possible duplicated metrics
that can arise from multiple projects.}

\item{discard_keys}{Character vector of strings that will be discarded
during creating BumpyMatrix object.}
}
\value{
Merged MultiAssayExperiment object.
}
\description{
Merge multiple MultiAssayExperiment objects
}
\examples{
mae1 <- get_synthetic_data("finalMAE_combo_2dose_nonoise")
mae2 <- get_synthetic_data("finalMAE_combo_2dose_nonoise")
merge_MAE(list(mae1 = mae1, mae2 = mae2))

}
\keyword{SE_operators}
