% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{remove_drug_batch}
\alias{remove_drug_batch}
\title{Remove batch substring from drug id}
\usage{
remove_drug_batch(
  drug_vec,
  drug_p = "^G[0-9]{8}",
  sep_p = "[^0-9|^_]",
  batch_p = ".+"
)
}
\arguments{
\item{drug_vec}{character vector with drug id(s)}

\item{drug_p}{string with regex pattern for drug id. Set to Gnumber format by default: "G[0-9]\{8\}".}

\item{sep_p}{string with regex pattern for separator. Set to any character except for digit and space}

\item{batch_p}{string with regex pattern for batch substring.
By default set to any character(s): ".+"}
}
\value{
charvec with Gnumber(s)
}
\description{
Gnumber, i.e. "G12345678" is currently the default format of drug_id. It's also used as a drug name in some cases.
}
\details{
By default, Gnumber(s) followed by any character (except for underscore and any digit)
and any batch substring are cleaned:
\itemize{
\item G00060245.18 => G00060245
\item G00060245.1-8 => G00060245
\item G02948263.1-1.DMA => G02948263
\item Gnumber followed by the codrug
\itemize{
\item G03252046.1-2;G00376771 => G03252046
}
\item Gnumber followed by the two codrugs
\itemize{
\item G03256376.1-2;G00376771.1-19;G02557755 => G03256376
}
\item Gnumber followed by the drug name
\itemize{
\item G00018838, Cisplatin => G00018838
}
}

By default, Gnumber(s) followed by the "_" or digit (regardless the batch substring) are not cleaned:
\itemize{
\item Gnumber with suffix added to prevent duplicated ids
\itemize{
\item G00060245_(G00060245.1-8)
}
\item too long Gnumber
\itemize{
\item G123456789.1-12
}
}
}
\examples{
remove_drug_batch("G00060245.18")
remove_drug_batch("G00060245.1-8")
remove_drug_batch("G00060245.1-1.DMA")

remove_drug_batch("G03252046.1-2;G00376771")
remove_drug_batch("G00018838, Cisplatin")
remove_drug_batch("G03256376.1-2;G00376771.1-19;G02557755")
remove_drug_batch("G00060245_(G00060245.1-8)")
remove_drug_batch(c("G00060245.18", "G00060245.1-8", "G00060245.1-1.DMA"))

remove_drug_batch("DRUG_01.123", drug_p = "DRUG_[0-9]+")
remove_drug_batch("G00001234:22-1", sep_p = ":")
remove_drug_batch("G00001234.28", batch_p = "[0-9]+")

}
\keyword{package_utils}
