% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_x_pb.R
\name{update_x_pb}
\alias{update_x_pb}
\title{update_x_p}
\usage{
update_x_pb(
  Model,
  mean_x = 1,
  sd_x = 1,
  mean_xx = 1,
  sd_xx = 1,
  cores = 1,
  verbose = FALSE
)
}
\arguments{
\item{Model}{a Model object of class gemini.model}

\item{mean_x}{a numeric indicating prior mean of x}

\item{sd_x}{a numeric indicating prior sd of x}

\item{mean_xx}{a numeric indicating prior mean of xx}

\item{sd_xx}{a numeric indicating prior sd of xx}

\item{cores}{a numeric indicating the number of cores to use.  See \code{\link[gemini]{gemini_parallelization}} for details.  (default=1).}

\item{verbose}{default FALSE}
}
\value{
An object of class gemini.model
}
\description{
Update values of x using data from \code{Input} and current values of other parameters.
}
\note{
The structure of the screen may impede parallelization. Our ability to parallelize the updates is 
contingent upon the independence between guides in position 1 and 2.
To account for potential dependence, we define three groups of guides: group 1 (guides only in position 1
), group 2 (guides only in position 2), and group 3 (guides in both position 1 and position 2). 
Parallelization is possible for groups 1 and 2, but only serial updates are possible for group 3. 
As such, updates for this group will take longer.
}
\examples{
data("Model", package = "gemini")
Model \%<>\% update_x_pb()

}
