% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trait_analysis.R
\name{analyze_trait_changes}
\alias{analyze_trait_changes}
\title{Differential analysis of glycan traits between experimental groups}
\usage{
analyze_trait_changes(trait_se, group_col, group_levels, min_psm = 20)
}
\arguments{
\item{trait_se}{A SummarizedExperiment containing trait matrices (one assay per trait),
typically returned by \code{\link{build_trait_se}}.}

\item{group_col}{The column name in `colData(trait_se)` defining sample group membership.}

\item{group_levels}{Character vector specifying which values of `group_col` to compare (e.g., `c("Control","Treatment")`).}

\item{min_psm}{Minimum required PSM count per group for statistical testing.
Default = 20.}
}
\value{
A data frame of significant trait–site (or trait–protein) comparisons with:
 \itemize{
    \item trait  — glycan trait name
    \item level  — site/protein identifier
    \item l_pval — Levene test p-value
    \item f_val  — Levene test F statistic
    \item t_pval — Welch t-test p-value
    \item t_val  — t-statistic
  }
Rows correspond only to significant comparisons (p < 0.05) for `l_pval` or `t_pval`.
}
\description{
Perform group-wise statistical testing on glycan trait matrices stored in a
SummarizedExperiment created by \code{\link{build_trait_se}}. For each glycan
trait and each site/protein row, the function compares trait intensities
across user-specified experimental groups using Welch’s t-test and
Levene’s variance test.
}
\details{
Each assay in `trait_se` represents a glycan trait matrix.
The rows as glycopeptides (site-level) or proteins (protein-level).
The columns are GPSM count found in samples.
For each trait × feature combination,
Extract PSM-level trait intensities for samples belonging to the specified `group_levels`.
Exclude traits where either group has fewer than `min_psm` GPSMs.
Exclude all-zero traits (boolean-like traits)
Run Welch two-sample t-test (`t.test`) and
Levene's variance test (`car::leveneTest`, median centered).
A result is returned only if either test shows p < 0.05.
}
\examples{
# Load toy pGlyco3 GPSM data included with the package
path <- system.file("extdata", "pGlyco3_gpsm_toyexample.txt",
  package = "glycoTraitR"
)
gpsm_toyexample <- read_pGlyco3_gpsm(path)

# Load accompanying toy metadata
data("meta_toyexample")

# Build glycan trait SummarizedExperiment at the protein level
trait_se <- build_trait_se(
  gpsm = gpsm_toyexample,
  from = "pGlyco3",
  motifs = NULL,
  level = "protein",
  meta = meta_toyexample
)

# Identify glycan traits significantly changed between groups
changed_traits <- analyze_trait_changes(
  trait_se     = trait_se,
  group_col    = "Diagnosis",
  group_levels = c("Normal", "Symptomatic"),
  min_psm      = 20
)
changed_traits

}
