% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glycan_structure.R
\name{build_glycan_igraph}
\alias{build_glycan_igraph}
\title{Construct an igraph representation of a glycan tree}
\usage{
build_glycan_igraph(tree)
}
\arguments{
\item{tree}{A parsed glycan tree from \code{\link{pGlyco3_to_tree}} or \code{\link{wurcs_to_tree}}.}
}
\value{
A directed `igraph` object representing the glycan structure.
}
\description{
Convert a parsed glycan tree into a directed
`igraph` object with parent–child relationships and residue-level
metadata suitable for structural motif detection.
}
\details{
The resulting graph contains the following vertex attributes:
\itemize{
  \item \code{name}    — synthetic node label (`"a"`, `"b"`, ...)
  \item \code{residue} — residue type (H, N, A, F, G)
  \item \code{type}    — identical to residue (for convenience)
  \item \code{color}   — color encoding of residue type
  \item \code{is_root} — TRUE if the vertex is the structural root
}
}
\examples{
# Example: parse a pGlyco3 monosaccharide expression into a glycan tree
pGlyco_expr <- "(N(N(H(H(H))(H(H)(H)(H(H))))))"

# Convert expression into a parsed tree structure
tree <- pGlyco3_to_tree(pGlyco_expr)
g <- build_glycan_igraph(tree)
g

}
