% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trait_compute.R
\name{build_trait_se}
\alias{build_trait_se}
\title{Build a SummarizedExperiment of glycan trait matrices}
\usage{
build_trait_se(gpsm, from, motifs = NULL, level, meta)
}
\arguments{
\item{gpsm}{A GPSM table containing at least:
`Protein`, `Peptide`, `GlycanStructure`, `File`, and `Count`.}

\item{from}{Character; glycan format used in the GPSM input.
One of `decipher` or `pGlyco3`.}

\item{motifs}{Optional named list of user-defined motif structures
passed to \link{compute_glycan_traits}.}

\item{level}{Summarization level. Either `site (peptide)` or `"protein"`.}

\item{meta}{Data frame of sample metadata with a column `file`
matching `gpsm$File`.}
}
\value{
A `SummarizedExperiment` where each assay is a glycan-trait
  matrix (trait × PSM), `rowData` contains peptide/protein names,
  and `colData` contains metadata aligned to PSMs.
}
\description{
Convert a GPSM table into peptide- or protein-level glycan trait matrices
and store them in a \code{SummarizedExperiment} object. Each trait becomes an assay
matrix whose rows represent peptides or proteins, and whose columns
represent individual GPSMs.
This function provides a unified container for downstream analyses such as
differential testing and visualization.
}
\examples{
# Load toy GPSM table exported by pGlyco3
path <- system.file("extdata", "pGlyco3_gpsm_toyexample.txt",
  package = "glycoTraitR"
)
gpsm_toyexample <- read_pGlyco3_gpsm(path)

# Load toy metadata for summarization
data("meta_toyexample")


# Build glycan trait SummarizedExperiment at protein level
trait_se <- build_trait_se(
  gpsm = gpsm_toyexample,
  from = "pGlyco3",
  motifs = NULL,
  level = "protein",
  meta = meta_toyexample
)

# Inspect assay names and dimensions
SummarizedExperiment::assayNames(trait_se)
dim(trait_se)

}
