% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trait_compute.R
\name{compute_glycan_traits}
\alias{compute_glycan_traits}
\title{Compute glycan traits from a parsed glycan tree}
\usage{
compute_glycan_traits(tree, motifs)
}
\arguments{
\item{tree}{A parsed glycan tree from \code{\link{pGlyco3_to_tree}} or \code{\link{wurcs_to_tree}}.}

\item{motifs}{Optional named list of user-defined glycan motifs.}
}
\value{
A named list of numeric trait values.
}
\description{
Combine residue-level composition traits (see \code{count_residues}),
structural traits (see \code{compute_structural_traits}), and
user-defined motifs (see \code{compute_userdefined_traits})
into a unified trait vector.
}
\examples{
# Example: parse a pGlyco3-style glycan expression into a tree
pGlyco_expr <- "(N(N(H(H(H))(H(H)(H)(H(H))))))"

# Convert to glycan tree structure
tree <- pGlyco3_to_tree(pGlyco_expr)

# Explore parsed nodes and edges
tree$node
tree$edge

# Build igraph representation
g <- build_glycan_igraph(tree)
plot_glycan_tree(g)

# Define user motifs for trait computation
user_motifs <- list(
  LinearH3 = list(
    node = c("H", "H", "H"),
    edge = c("a-b", "b-c")
  ),
  FucBranch = list(
    node = c("H", "N", "F"),
    edge = c("a-b", "b-c")
  )
)

# Compute glycan structural traits
compute_glycan_traits(tree, motifs = user_motifs)

}
