% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_glyco_traits.R
\name{plot_trait_distribution}
\alias{plot_trait_distribution}
\title{Plot the distribution of a glycan trait across experimental groups}
\usage{
plot_trait_distribution(trait_se, group_col, group_levels, trait_name, feature)
}
\arguments{
\item{trait_se}{A SummarizedExperiment object generated by \link{build_trait_se},
containing one assay matrix per glycan trait.}

\item{group_col}{Column name in `colData(trait_se)` that defines sample group membership.}

\item{group_levels}{Character vector specifying the group values to include in the plot.
Typically two values (e.g. `c("Control","Treatment")`).}

\item{trait_name}{Name of the glycan trait to plot. Must match an assay name in
`assays(trait_se)`.}

\item{feature}{Row identifier within the trait matrix (peptide, or protein).
Must match a row name in `assays(trait_se)[[trait_name]]`.}
}
\value{
A named list of two `ggplot2` objects:
* `p_hist` — histogram of trait intensities
* `p_box`  — boxplot with jitter overlay
}
\description{
Generate two diagnostic plots—a histogram and a boxplot—for a selected
glycan trait at a specific site/protein feature.
This function extracts GPSM-level values from a trait matrix stored in a
`SummarizedExperiment`, subsets them by group, removes missing values,
and visualizes the resulting distribution.
}
\examples{
# Load the toy GPSM table exported by pGlyco3 (included in the package)
path <- system.file("extdata", "pGlyco3_gpsm_toyexample.txt",
  package = "glycoTraitR"
)
gpsm_toyexample <- read_pGlyco3_gpsm(path)

# Load the accompanying toy metadata
data("meta_toyexample")

# Build a protein-level glycan trait SummarizedExperiment object
trait_se <- build_trait_se(
  gpsm = gpsm_toyexample,
  from = "pGlyco3",
  motifs = NULL,
  level = "protein",
  meta = meta_toyexample
)

# Identify glycan traits significantly changed between two groups
changed_traits <- analyze_trait_changes(
  trait_se     = trait_se,
  group_col    = "Diagnosis",
  group_levels = c("Normal", "Symptomatic"),
  min_psm      = 20
)

# Extract one trait name and one protein/site feature to visualize
trait_name <- changed_traits$trait[1]
feature <- changed_traits$level[1]

# Plot the distribution of this selected trait
p <- plot_trait_distribution(
  trait_se     = trait_se,
  group_col    = "Diagnosis",
  group_levels = c("Normal", "Symptomatic"),
  trait_name   = trait_name,
  feature      = feature
)

# Show histogram and boxplot
p$p_hist
p$p_box

}
