% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_gpsm_import.R
\name{read_decipher_gpsm}
\alias{read_decipher_gpsm}
\title{Combine Glyco-Decipher GPSM results into a long-format table}
\usage{
read_decipher_gpsm(gpsm_folder_dir)
}
\arguments{
\item{gpsm_folder_dir}{The path to a folder containing Glyco-Decipher GPSM files (e.g. files ending with
\code{"_GPSM_DatabaseGlycan.txt"}).}
}
\value{
A data frame in long format with one row per
\code{Protein}–\code{Peptide}–\code{GlycanStructure}–\code{File}
combination and the following columns:

\itemize{
  \item \code{Protein} — protein identifier(s)
  \item \code{Peptide} — peptide sequence
  \item \code{GlycanStructure} — glycan structural annotation (WURCS 2.0)
  \item \code{File} — raw file name
  \item \code{Count} — spectral count (number of GPSMs) for this combination
}

The returned table is designed to be passed to
\code{\link{build_trait_se}} for glycan trait computation.
}
\description{
Read multiple Glyco-Decipher GPSM files from a folder,
merge them into a unified protein–peptide–glycan table, and attach
glycan structures (WURCS 2.0).
}
\details{
This function assumes that the input folder contains one or more
Glyco-Decipher GPSM files, typically named with the suffix
\code{"_GPSM_DatabaseGlycan.txt"}. For each file,
GPSM records are read and collapsed by \code{Protein}, \code{Peptide},
\code{GlycanID}, \code{File}, and \code{Count}.
All files are then combined into a single table, and glycan IDs are
mapped to WURCS structures via the global \code{glycanDatabase} object.
The final table uses a standardized glycan column name
\code{GlycanStructure} for compatibility with downstream functions.
}
\examples{
folder <- system.file("extdata", "decipher_toyexample", package = "glycoTraitR")
gpsm <- read_decipher_gpsm(folder)
head(gpsm)

}
\seealso{
\code{\link{read_pGlyco3_gpsm}},
\code{\link{build_trait_se}}
}
