% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_gpsm_import.R
\name{read_pGlyco3_gpsm}
\alias{read_pGlyco3_gpsm}
\title{Import pGlyco3 GPSM results as a long-format table}
\usage{
read_pGlyco3_gpsm(gpsm_dir)
}
\arguments{
\item{gpsm_dir}{The path to the pGlyco3 GPSM output file
(for example, \code{"pGlycoDB-GP-FDR-Pro-Quant-Site.txt"}).}
}
\value{
A data frame with one row per
\code{Protein}–\code{Peptide}–\code{GlycanStructure}–\code{File}
combination and the following columns:

\itemize{
  \item \code{Protein} — protein identifier(s)
  \item \code{Peptide} — peptide sequence
  \item \code{GlycanStructure} — glycan structural annotation from pGlyco3
  \item \code{File} — raw file name
  \item \code{Count} — spectral count (number of GPSMs) for this combination
}
}
\description{
Read a pGlyco3 GPSM result file and convert it into a long-format
protein–peptide–glycan table with spectral counts per raw file.
Each row corresponds to a unique combination of protein, peptide,
glycan structure, and file.
}
\details{
This function takes a pGlyco3 GPSM file as input (typically named
\code{pGlycoDB-GP-FDR-Pro-Quant-Site.txt}). The following steps are performed:

\itemize{
  \item Select relevant columns (\code{RawName}, \code{Proteins},
        \code{Peptide}, \code{PlausibleStruct}).
  \item Rename them to a standardized schema:
        \code{File}, \code{Protein}, \code{Peptide}, \code{GlycanStructure}.
  \item Collapse multiple protein IDs per PSM into a single
        pipe-separated string (e.g. \code{"P00123|P00456"}).
  \item Aggregate rows by \code{Protein}, \code{Peptide},
        \code{GlycanStructure}, and \code{File} as GPSM counts in each group.
}

The output of this function is typically used as the input for
\code{\link{build_trait_se}}.
}
\examples{
# Load toy example data included in glycoTraitR
path <- system.file("extdata", "pGlyco3_gpsm_toyexample.txt",
  package = "glycoTraitR"
)
gpsm <- read_pGlyco3_gpsm(path)
head(gpsm)

}
\seealso{
\code{\link{read_decipher_gpsm}},
\code{\link{build_trait_se}}
}
