% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_current_gwascat.R
\name{get_cached_gwascat}
\alias{get_cached_gwascat}
\title{use BiocFileCache to retrieve and keep an image of the tsv file distributed by EBI}
\usage{
get_cached_gwascat(
  url = "https://www.ebi.ac.uk/gwas/api/search/downloads/associations/v1.0?split=false",
  cache = BiocFileCache::BiocFileCache(),
  refresh = FALSE,
  ...
)
}
\arguments{
\item{url}{character(1) url to use}

\item{cache}{BiocFileCache::BiocFileCache instance}

\item{refresh}{logical(1) force download and recaching}

\item{\dots}{passed to bfcadd}
}
\value{
a tibble from data.frame as produced by data.table::fread, with attributes extractDate (as
recorded in cache as `access_time`
}
\description{
use BiocFileCache to retrieve and keep an image of the tsv file distributed by EBI
}
\note{
If query of cache with 'ebi.ac.uk/gwas' returns 0-row tibble,
will populate cache with bfcadd.  Uses data.table::fread on cache content to return tibble.
The etag field does not seem to be used at EBI, thus user must check for updates.
}
