% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HermesData-class.R
\docType{class}
\name{HermesData-class}
\alias{HermesData-class}
\alias{.HermesData}
\alias{HermesData}
\alias{RangedHermesData}
\alias{AnyHermesData}
\alias{RangedHermesData-class}
\alias{.RangedHermesData}
\alias{AnyHermesData-class}
\alias{HermesDataFromMatrix}
\title{\code{HermesData} and \code{RangedHermesData}}
\usage{
HermesData(object)

HermesDataFromMatrix(counts, ...)
}
\arguments{
\item{object}{(\code{SummarizedExperiment})\cr input to create the \code{\link{HermesData}} object from.
If this is a \code{RangedSummarizedExperiment}, then the result will be
\code{\link{RangedHermesData}}.}

\item{counts}{(\code{matrix})\cr counts to create the \code{\link{HermesData}} object from.}

\item{...}{additional arguments, e.g. \code{rowData}, \code{colData}, etc. passed to
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment()}} internally. Note that if \code{rowRanges}
is passed instead of \code{rowData}, then the result will be a \code{\link{RangedHermesData}} object.}
}
\value{
An object of class \code{\link{AnyHermesData}} (\code{\link{HermesData}} or \code{\link{RangedHermesData}}).
}
\description{
The \code{\link{HermesData}} class is an extension of \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment}}
with additional validation criteria.
}
\details{
The additional criteria are:
\itemize{
\item The first assay must be \code{counts} containing non-missing, integer, non-negative values.
Note that \code{\link[=rename]{rename()}} can be used to edit the assay name to \code{counts} if needed.
\item The following columns must be in \code{rowData}:
\itemize{
\item \code{symbol} (also often called \code{HGNC} or similar, example: \code{"INMT"})
\item \code{desc} (the gene name, example: \code{"indolethylamine N-methyltransferase"})
\item \code{chromosome} (the chromosome as string, example: \code{"7"})
\item \code{size} (the size of the gene in base pairs, e.g \code{5468})
\item \code{low_expression_flag} (can be populated with \code{\link[=add_quality_flags]{add_quality_flags()}})
}
\item The following columns must be in \code{colData}:
\itemize{
\item \code{low_depth_flag} (can be populated with \code{\link[=add_quality_flags]{add_quality_flags()}})
\item \code{tech_failure_flag} (can be populated with \code{\link[=add_quality_flags]{add_quality_flags()}})
}
\item The object must have unique row and column names. The row names are the gene names
and the column names are the sample names.
}

Analogously, \code{\link{RangedHermesData}} is an extension of
\code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{SummarizedExperiment::RangedSummarizedExperiment}} and has the same
additional validation requirements. Methods can be defined for both classes at the
same time with the \code{\link{AnyHermesData}} signature.

A \code{\link[Biobase:class.ExpressionSet]{Biobase::ExpressionSet}} object can be imported by using the
\code{\link[SummarizedExperiment:makeSummarizedExperimentFromExpressionSet]{SummarizedExperiment::makeSummarizedExperimentFromExpressionSet()}} function to
first convert it to a \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment}} object before
converting it again into a \code{\link{HermesData}} object.
}
\section{Slots}{

\describe{
\item{\code{prefix}}{common prefix of the gene IDs (row names).}
}}

\note{
\itemize{
\item Note that we use \code{\link[S4Vectors:S4Vectors-internals]{S4Vectors::setValidity2()}} to define the validity
method, which allows us to turn off the validity checks in internal
functions where intermediate objects may not be valid within the scope of
the function.
\item It can be helpful to convert character and logical variables to factors in \code{colData()}
(before or after the \code{HermesData} creation). We provide the utility function
\code{\link[=df_cols_to_factor]{df_cols_to_factor()}} to simplify this task, but leave it to the user to allow
for full control of the details.
}
}
\examples{
# Convert an `ExpressionSet` to a `RangedSummarizedExperiment`.
ranged_summarized_experiment <- makeSummarizedExperimentFromExpressionSet(expression_set)

# Then convert to `RangedHermesData`.
HermesData(ranged_summarized_experiment)

# Create objects starting from a `SummarizedExperiment`.
hermes_data <- HermesData(summarized_experiment)
hermes_data

# Create objects from a matrix. Note that additional arguments are not required but possible.
counts_matrix <- assay(summarized_experiment)
counts_hermes_data <- HermesDataFromMatrix(counts_matrix)
}
\seealso{
\code{\link[=rename]{rename()}} for renaming columns of the input data.
}
