% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{draw_nonzero_boxplot}
\alias{draw_nonzero_boxplot}
\title{Boxplot of Non-Zero Genes}
\usage{
draw_nonzero_boxplot(object, position = position_jitter(0.2), alpha = 0.25)
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr input.}

\item{position}{(\code{Position})\cr specifies x-axis position of points, e.g. for jittering.}

\item{alpha}{(\code{proportion})\cr specifies transparency of points.}
}
\value{
The \code{ggplot} object with the boxplot.
}
\description{
This draws a boxplot, with overlaid data points, of the number of
non-zero expressed genes per sample.
}
\examples{
# Default boxplot.
result <- hermes_data
draw_nonzero_boxplot(result)

# Reusing the same position for labeling.
library(ggrepel)
pos <- position_jitter(0.5)
draw_nonzero_boxplot(result, position = pos) +
  geom_text_repel(aes(label = samples(result)), position = pos)
}
