% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HermesData-methods.R, R/dplyr_compatibility.R
\name{filter}
\alias{filter}
\alias{filter,AnyHermesData-method}
\alias{filter,data.frame-method}
\alias{filter,ts-method}
\title{Filter \code{AnyHermesData} on Subset Passing Default QC Flags}
\usage{
filter(object, ...)

\S4method{filter}{AnyHermesData}(object, what = c("genes", "samples"), annotation_required = "size")

\S4method{filter}{data.frame}(object, ...)

\S4method{filter}{ts}(object, ...)
}
\arguments{
\item{object}{(\code{AnyHermesData})\cr object to filter.}

\item{...}{additional arguments.}

\item{what}{(\code{character})\cr specify whether to apply the filter on \code{genes} and / or \code{samples}.}

\item{annotation_required}{(\code{character})\cr names of required \code{\link{annotation}} columns for genes. Only
used when \code{genes} are filtered.}
}
\value{
The filtered \code{\link{AnyHermesData}} object.
}
\description{
This filters a \code{\link{AnyHermesData}} object using the default QC flags and required annotations.
}
\details{
\itemize{
\item Only genes without low expression (\code{low_expression_flag}) and samples
without low depth (\code{low_depth_flag}) or technical failure (\code{tech_failure_flag})
remain in the returned filtered object.
\item Also required gene annotation columns can be specified, so that genes which are not complete
for these columns are filtered out. By default this is the \code{size} column, which is needed
for default normalization of the object.
}
}
\note{
The internal implementation cannot use the \code{\link[=subset]{subset()}} method since that
requires non-standard evaluation of arguments.
}
\examples{
a <- hermes_data
dim(a)

# Filter genes and samples on default QC flags.
result <- filter(a)
dim(result)

# Filter only genes without low expression.
result <- filter(a, what = "genes")

# Filter only samples with low depth and technical failure.
result <- filter(a, what = "samples")

# Filter only genes, and require certain annotations to be present.
result <- filter(a, what = "genes", annotation_required = c("size"))
}
