% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connections.R
\name{h_get_size_biomart}
\alias{h_get_size_biomart}
\title{Total Length of All Exons for Genes}
\usage{
h_get_size_biomart(gene_ids, id_var, mart)
}
\arguments{
\item{gene_ids}{(\code{character})\cr gene IDs, e.g. \code{10329}, i.e. already
without the \code{Entrez} \code{GeneID} prefix, or \code{ENSG00000241644} for \code{Ensembl} gene ID.}

\item{id_var}{(\code{string})\cr corresponding gene ID variable name in \code{BioMart},
i.e. \code{entrezgene_id} or \code{ensembl_gene_id}.}

\item{mart}{(\code{Mart})\cr given \code{\link[biomaRt:Mart-class]{biomaRt::Mart}} object.}
}
\value{
Named integer vector indicating the gene lengths.
}
\description{
This helper function queries \code{BioMart} for lengths of genes by adding up all
exon lengths after reducing overlaps.
}
\examples{
if (interactive()) {
  mart <- biomaRt::useMart("ensembl", dataset = "hsapiens_gene_ensembl")
  h_get_size_biomart("11185", "entrezgene_id", mart)
  h_get_size_biomart("ENSG00000215417", "ensembl_gene_id", mart)
  h_get_size_biomart(c("11185", "10677"), "entrezgene_id", mart)
  h_get_size_biomart(c("ENSG00000135407", "ENSG00000215417"), "ensembl_gene_id", mart)
}
}
