% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HermesData-validate.R
\name{validate}
\alias{validate}
\alias{validate_counts}
\alias{validate_cols}
\alias{validate_row_data}
\alias{validate_col_data}
\alias{validate_names}
\alias{validate_prefix}
\title{Internal Helper Functions for Validation of \code{AnyHermesData} Objects}
\usage{
validate_counts(object)

validate_cols(required, actual)

validate_row_data(object)

validate_col_data(object)

validate_names(object)

validate_prefix(object)
}
\arguments{
\item{object}{(\code{SummarizedExperiment})\cr object to validate.}

\item{required}{(\code{character})\cr required column names.}

\item{actual}{(\code{actual})\cr actual column names.}
}
\value{
A character vector with the validation failure messages, or \code{NULL} in
case validation passes.
}
\description{
These functions are used internally only and therefore not exported. They work on
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment}} objects, and \code{\link{AnyHermesData}} objects are
defined by successfully passing these validation checks.
}
\section{Functions}{
\itemize{
\item \code{validate_counts()}: validates that the first assay is \code{counts} containing
non-missing, integer, non-negative values.

\item \code{validate_cols()}: validates that required column names are contained in
actual column names.

\item \code{validate_row_data()}: validates that the object contains \code{rowData} with
required columns.

\item \code{validate_col_data()}: validates that the object contains \code{colData} with
required columns.

\item \code{validate_names()}: validates that the object contains row and column names.

\item \code{validate_prefix()}: validates that the object prefix is a string
and only contains alphabetic characters.

}}
