% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KDNorm.R
\docType{data}
\name{KDNorm}
\alias{KDNorm}
\title{Kyte and Doolittle Scaled Hydropathy Index}
\format{
a data frame with 20 rows, one for each standard amino acid, and
  2 variables
\describe{
   \item{V1}{Amino acid residues as a single letter}
   \item{V2}{Scaled Hydropathy of a residue, measured 0-1}
 }
}
\source{
Kyte, Jack, and Russell F. Doolittle.
  "A simple method for displaying the hydropathic character of a protein."
  Journal of molecular biology 157.1 (1982): 105-132.
  \url{https://doi.org/10.1016/0022-2836(82)90515-0}
}
\usage{
KDNorm
}
\description{
A dataset containing a measure of hydropathy for each amino acid residue
  as reported by Kyte J. and Doolittle R.F. (1982). Values normalized from
  0 to 1. \cr If you use these values, please cite the source article.
}
\seealso{
Other scaled hydropathy functions: 
\code{\link{foldIndexR}()},
\code{\link{meanScaledHydropathy}()},
\code{\link{scaledHydropathyGlobal}()},
\code{\link{scaledHydropathyLocal}()}
}
\concept{scaled hydropathy functions}
\keyword{datasets}
