% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{remove_nonstandard_chromosomes1d}
\alias{remove_nonstandard_chromosomes1d}
\title{Removes Peaks on Non-standard Chromosomes}
\usage{
remove_nonstandard_chromosomes1d(x)
}
\arguments{
\item{x}{data frame of genomic peaks, with the following columns
(position of columns matter, column names are irrelevant):
\tabular{rll}{
  column 1: \tab \code{chr} \tab character; genomic location of peak -
  chromosome (e.g., \code{"chr3"})\cr
  column 2: \tab \code{start} \tab integer; genomic location of peak  -
  start coordinate\cr
  column 3: \tab \code{end} \tab integer; genomic location of peak -
  end coordinate\cr
  column 4: \tab \code{value} \tab numeric; p-value, FDR, or heuristic used
  to rank the peaks
}}
}
\value{
\code{x} without non-standard chromosomes.
}
\description{
Removes Peaks on Non-standard Chromosomes
}
\examples{
rep1_df <- remove_nonstandard_chromosomes1d(idr2d:::chipseq$rep1_df)

}
