% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainOGRDB.R
\name{getOGRDB}
\alias{getOGRDB}
\title{Download and Load Immune Receptor Germline Sequences from OGRDB}
\usage{
getOGRDB(
  species = "human",
  locus = c("IGH", "IGK", "IGL"),
  set_name = NULL,
  type = c("NUC", "PROT"),
  format = c("FASTA_GAPPED", "FASTA_UNGAPPED", "AIRR"),
  version = c("published", "latest"),
  species_subgroup = NULL,
  refresh = FALSE,
  suppressMessages = FALSE
)
}
\arguments{
\item{species}{Character string specifying the species. Accepts
\code{"human"}, \code{"Homo sapiens"}, \code{"mouse"}, or
\code{"Mus musculus"}. Default is \code{"human"}.}

\item{locus}{Character string specifying the locus short code. One of
\code{"IGH"}, \code{"IGK"}, or \code{"IGL"}. Can be \code{NULL} if you pass
a \code{set_name} explicitly.}

\item{set_name}{Optional character string specifying an explicit OGRDB set
name (e.g., \code{"IGH_VDJ"}). If provided, overrides \code{locus}.}

\item{type}{Character string specifying the sequence type. Either
\code{"NUC"} (default) for nucleotide or \code{"PROT"} for protein.
\code{"PROT"} will translate V-gene CDS; only supported for FASTA or AIRR
records that include a valid CDS.}

\item{format}{Character string specifying the download format. One of
\code{"FASTA_GAPPED"} (default), \code{"FASTA_UNGAPPED"}, or \code{"AIRR"}.}

\item{version}{Character string specifying the version. Either
\code{"published"} (default) or \code{"latest"}.}

\item{species_subgroup}{Optional character string specifying a subgroup
(e.g., a mouse strain like \code{"C57BL/6"}). If it contains \code{/},
OGRDB requires it encoded as \code{\%252f}.}

\item{refresh}{Logical. If \code{TRUE}, forces re-download even if cached.
Default is \code{FALSE}.}

\item{suppressMessages}{Logical. If \code{TRUE}, suppresses informational
messages. Default is \code{FALSE}.}
}
\value{
A \code{\link[Biostrings]{DNAStringSet}} object (when
  \code{type = "NUC"}) or \code{\link[Biostrings]{AAStringSet}} object (when
  \code{type = "PROT"}) containing the requested sequences.
}
\description{
Downloads AIRR-compliant germline sets (or FASTA) from OGRDB
(Open Germline Receptor Database) and returns sequences as a
\code{\link[Biostrings]{DNAStringSet}} or
\code{\link[Biostrings]{AAStringSet}}.
}
\details{
OGRDB (Open Germline Receptor Database) is the AIRR Community's curated
repository of germline receptor sequences. It complements IMGT with
additional species support and standardized AIRR JSON format.

The function supports multiple download formats:
\itemize{
  \item \code{FASTA_GAPPED}: FASTA with IMGT gaps preserved
  \item \code{FASTA_UNGAPPED}: FASTA without gaps
  \item \code{AIRR}: AIRR-C compliant JSON format
}
}
\examples{
if (is_ogrdb_available()) {
  # Download human IGH nucleotide sequences (gapped FASTA)
  igh_nuc <- getOGRDB(species = "human",
                      locus   = "IGH",
                      type    = "NUC",
                      format  = "FASTA_GAPPED")

  # Download human IGK sequences in AIRR JSON format
  igk_airr <- getOGRDB(species = "human",
                       locus   = "IGK",
                       type    = "NUC",
                       format  = "AIRR")

  # Download human IGL sequences and translate to AA
  igl_prot <- getOGRDB(species = "human",
                       locus   = "IGL",
                       type    = "PROT",
                       format  = "FASTA_UNGAPPED")

  # Example using an explicit set name (instead of locus)
  igh_explicit <- getOGRDB(species  = "human",
                           set_name = "IGH_VDJ",
                           type     = "NUC",
                           format   = "FASTA_GAPPED")
}
}
\seealso{
\code{\link{loadOGRDB}}, \code{\link{refreshOGRDB}} for convenience wrappers

\code{\link{getIMGT}} for IMGT sequences

\code{\link{exportMiXCR}}, \code{\link{exportTRUST4}},
\code{\link{exportCellRanger}}, \code{\link{exportIgBLAST}} for exporting
sequences to analysis tools

\url{https://ogrdb.airr-community.org/} for OGRDB documentation
}
