% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interacCircos.R
\name{CircosHeatmap}
\alias{CircosHeatmap}
\title{HEATMAP module}
\usage{
CircosHeatmap(
  modulename,
  compareGroup = 1,
  maxRadius = 180,
  minRadius = 100,
  minColor = "red",
  maxColor = "green",
  ValueAxisManualScale = FALSE,
  ValueAxisMaxScale = 10,
  ValueAxisMinScale = 0,
  totalLayer = 1,
  animationDisplay = FALSE,
  animationDirection = "O2I",
  animationColorDirection = "L2C",
  animationTime = 2000,
  animationDelay = 20,
  animationType = "bounce",
  data,
  ...
)
}
\arguments{
\item{modulename}{The name of the new module}

\item{compareGroup}{The group number of this module in compare module}

\item{maxRadius, minRadius}{Where the module should begin and end}

\item{minColor}{The color for heatmap of min value}

\item{maxColor}{The color for heatmap of max value}

\item{ValueAxisManualScale}{Whether manually control the scale of value}

\item{ValueAxisMaxScale, ValueAxisMinScale}{The max and min scale value for manually control}

\item{totalLayer}{The color and width for stroke}

\item{animationDisplay}{Whether display animation}

\item{animationDirection}{The direction for animation. O2I: from outside to inside, I2O: from inside to outside}

\item{animationColorDirection}{The color changing in animation. L2C: lowest to customized, H2C: highest to customized, the customized color should be defined in data}

\item{animationTime, animationDelay, animationType}{The time, delay and display type for animation}

\item{data}{A list of value in heatmap plot with details including chr, start, end, value, name, layer and html.
Details can be found on document}

\item{...}{Ignored}
}
\value{
The module tracks for heatmap modules.
}
\description{
Create a heatmap plot
}
\examples{
heatmapData<-heatmapExample
Circos(CircosHeatmap('Heatmap01', maxRadius= 180, minRadius = 100, data=heatmapData,totalLayer = 3),
genome = list("2L"=23011544,"2R"=21146708,"3L"=24543557,"3R"=27905053,"4"=1351857,"X"=22422827),
HEATMAPMouseEvent = TRUE,HEATMAPMouseOverDisplay = TRUE)

}
