% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isomiRs.R
\name{isoTop}
\alias{isoTop}
\title{Heatmap of the top expressed isomiRs}
\usage{
isoTop(ids, top = 20, condition = NULL)
}
\arguments{
\item{ids}{Object of class \link{IsomirDataSeq}.}

\item{top}{Number of isomiRs/miRNAs used.}

\item{condition}{Give condition to color PCA samples}
}
\value{
PCA of the top expressed miRNAs
}
\description{
This function creates a heatmap with the top N
isomiRs/miRNAs. It uses the matrix under \code{counts(ids)}
to get the top expressed isomiRs/miRNAs using the average
expression value
and plot a heatmap with the raw counts for each sample.
}
\examples{
data(mirData)
isoTop(mirData)
}
