% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KYCG_plotManhattan.R
\name{KYCG_plotManhattan}
\alias{KYCG_plotManhattan}
\title{KYCG_plotManhattan makes a manhattan plot to summarize EWAS results}
\usage{
KYCG_plotManhattan(
  vals,
  platform = NULL,
  genome = NULL,
  title = NULL,
  rasterize = FALSE,
  rasterize_thres = 3,
  label_min = 100,
  col = c("wheat1", "sienna3"),
  ylabel = "Value"
)
}
\arguments{
\item{vals}{named vector of values (P,Q etc), vector name is Probe ID.}

\item{platform}{String corresponding to the type of platform to use for
retrieving GRanges coordinates 
of probes. Either MM285, EPIC, HM450, or HM27. If it is not provided, it
will be inferred from the query set probeIDs (Default: NA).}

\item{genome}{hg38, mm10, ..., will infer if not given.
For additional mapping, download the GRanges object from
http://zwdzwd.github.io/InfiniumAnnotation
and provide the following argument
..., genome = sesameAnno_buildManifestGRanges("downloaded_file"),...
to this function.}

\item{title}{title for plot}

\item{rasterize}{if true use ggrastr to rasterize non-significant data.}

\item{rasterize_thres, }{the threshold of rasterize}

\item{label_min}{Threshold above which data points will be labelled with
Probe ID}

\item{col}{color}

\item{ylabel}{y-axis label}
}
\value{
a ggplot object
}
\description{
KYCG_plotManhattan makes a manhattan plot to summarize EWAS results
}
\examples{

library(sesameData)

## Create example with simulated -log10(p-values)
## Mix of non-significant (low values) and significant (high values)
probes <- names(sesameData_getManifestGRanges("HM450"))
set.seed(123)
vals <- setNames(
    c(runif(990, 0, 3),      # Non-significant probes
      runif(10, 5, 25)),     # Significant probes
    sample(probes, 1000)
)

KYCG_plotManhattan(vals,
    platform = "HM450",
    title = "Example Manhattan Plot",
    ylabel = "-log10(P-value)",
    label_min = 20)

}
