#' lcmsPlot: Comprehensive Liquid Chromatography-Mass Spectrometry (LC-MS)
#' data visualisation package
#'
#' lcmsPlot offers flexible and powerful visualisation of raw and processed
#' LC-MS data. It supports chromatograms, mass spectra, and other plot types,
#' combining high performance with broad customisation.
#' Designed for large datasets, it facilitates assessment of signal quality,
#' feature comparison across samples, and generation of
#' publication-ready figures.
#'
#' @details
#' **Main features**
#'
#' - Unified, intuitive, and ggplot2-like interface.
#' - Plot from different types of sources, such as raw files (e.g. mzML),
#' XCMS objects (e.g., `XCMSnExp`), or Compound Discoverer results.
#' - Plot chromatograms, mass traces, spectra, and more.
#' - Combine different types of LC-MS data plots (e.g. chromatograms with
#' spectra).
#' - Arrange plots in different ways according to metadata factors.
#' - Large-scale plotting through iterative batching.
#'
#' @aliases lcmsPlot-package
"_PACKAGE"

## usethis namespace: start
## usethis namespace: end
NULL
