% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-source-mzmine.R
\name{MZmineFeatureListsSource}
\alias{MZmineFeatureListsSource}
\title{Create an MZmine data source from feature lists}
\usage{
MZmineFeatureListsSource(
  feature_lists_paths,
  sample_paths,
  metadata_path = NULL
)
}
\arguments{
\item{feature_lists_paths}{A \code{character} vector of paths to MZmine
feature list files (CSV or TSV).}

\item{sample_paths}{A \code{character} vector of paths to raw sample files
(e.g., \code{mzML}).}

\item{metadata_path}{A \code{character} value (optional) indicating the
path to a metadata file (CSV or TSV).
If \code{NULL}, a metadata \code{data.frame} is created from \code{sample_paths}.}
}
\value{
An object of class \code{ExternalDataSource}.
}
\description{
This function reads MZmine feature list files (supports version 2 and above)
and sample metadata and converts them into a format compatible
with xcms-style peak tables.
}
\examples{
## Create temporary example files
tmp_dir <- tempdir()

## Fake sample paths
sample_paths <- file.path(
  tmp_dir,
  c("sample1.mzML", "sample2.mzML")
)

## Create a minimal MZmine 2 feature list CSV
feature_list_path <- file.path(tmp_dir, "mzmine_features.csv")

mzmine_features <- data.frame(
  "row m/z" = c(100.1, 200.2),
  "sample1.mzML Feature status" = c("DETECTED", "DETECTED"),
  "sample1.mzML Feature m/z" = c(100.1, 200.2),
  "sample1.mzML Feature RT" = c(300, 600),
  "sample1.mzML Peak area" = c(10000, 20000),
  "sample1.mzML Peak height" = c(500, 800),
  "sample1.mzML Feature m/z min" = c(99.9, 199.9),
  "sample1.mzML Feature m/z max" = c(100.3, 200.4),
  "sample1.mzML Feature RT start" = c(290, 590),
  "sample1.mzML Feature RT end" = c(310, 610),
  check.names = FALSE
)

utils::write.csv(mzmine_features, feature_list_path, row.names = FALSE)

## Create the data source
ds <- MZmineFeatureListsSource(
  feature_lists_paths = feature_list_path,
  sample_paths = sample_paths
)
}
