% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-source-ms-dial.R
\name{MsDialPeaksSource}
\alias{MsDialPeaksSource}
\title{Create an MS-DIAL data source from peak lists}
\usage{
MsDialPeaksSource(peaks_paths, sample_paths, metadata_path = NULL)
}
\arguments{
\item{peaks_paths}{A \code{character} vector of paths to MS-DIAL
peak list files (CSV or TSV). The ordering should match the one
in the metadata (i.e., the samples).}

\item{sample_paths}{A \code{character} vector of paths to raw sample files
(e.g., \code{mzML}).}

\item{metadata_path}{A \code{character} value (optional) indicating the
path to a metadata file (CSV or TSV).
If \code{NULL}, a metadata \code{data.frame} is created from \code{sample_paths}.}
}
\value{
An object of class \code{ExternalDataSource}.
}
\description{
This function reads MS-DIAL peak list files and sample metadata
and converts them into a format compatible with xcms-style peak tables.
}
\examples{
## Create temporary example files
tmp_dir <- tempdir()

## Fake raw sample paths
sample_paths <- file.path(
  tmp_dir,
  c("sample1.mzML", "sample2.mzML")
)

## Create minimal MS-DIAL peak list files (one per sample)
peak_list_paths <- file.path(
  tmp_dir,
  c("sample1_peaks.csv", "sample2_peaks.csv")
)

msdial_peaks_1 <- data.frame(
  "Precursor m/z" = c(100.1, 200.2),
  "RT (min)" = c(5.0, 10.0),
  "Area" = c(10000, 20000),
  "Height" = c(500, 800),
  "RT left(min)" = c(4.8, 9.8),
  "RT right (min)" = c(5.2, 10.2),
  check.names = FALSE
)

msdial_peaks_2 <- data.frame(
  "Precursor m/z" = c(150.3, 250.4),
  "RT (min)" = c(6.0, 12.0),
  "Area" = c(15000, 25000),
  "Height" = c(600, 900),
  "RT left(min)" = c(5.8, 11.8),
  "RT right (min)" = c(6.2, 12.2),
  check.names = FALSE
)

utils::write.csv(msdial_peaks_1, peak_list_paths[1], row.names = FALSE)
utils::write.csv(msdial_peaks_2, peak_list_paths[2], row.names = FALSE)

## Create the data source
ds <- MsDialPeaksSource(
  peaks_paths = peak_list_paths,
  sample_paths = sample_paths
)
}
