% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlotDataContainer-class.R
\name{create_data_container_from_obj}
\alias{create_data_container_from_obj}
\title{Create an instance of class \code{lcmsPlotDataContainer} from a data object}
\usage{
create_data_container_from_obj(data_obj, sample_id_column, metadata)
}
\arguments{
\item{data_obj}{The data object (see \code{lcmsPlotDataContainer}).}

\item{sample_id_column}{A \code{character} value indicating the sample ID column.}

\item{metadata}{A \code{data.frame} containing the samples metadata
in case it is not provided in the dataset object.}
}
\value{
An instance of class \code{lcmsPlotDataContainer}. The object
contains the input data and the standardised metadata.
}
\description{
The \code{create_data_container_from_obj} function creates an instance
of class \code{lcmsPlotDataContainer} given a data object.
See \code{lcmsPlotDataContainer} for more information about the
supported data objects.
}
\examples{
raw_files <- dir(
   system.file("cdf", package = "faahKO"),
   full.names = TRUE,
   recursive = TRUE)[1:5]

data_container <- create_data_container_from_obj(
  data_obj = raw_files,
  sample_id_column = NULL,
  metadata = NULL
)
}
\keyword{internal}
