% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-data.R
\name{get_adjusted_rts}
\alias{get_adjusted_rts}
\title{Retrieve raw and adjusted retention times from an xcms object}
\usage{
get_adjusted_rts(obj)
}
\arguments{
\item{obj}{An object potentially containing xcms-processed LC-MS data.}
}
\value{
A \code{data.frame} with one row per detected feature, containing:
\describe{
\item{file_index}{Index of the originating raw data file.}
\item{raw_rt}{Original (unadjusted) retention time.}
\item{adj_rt}{Adjusted retention time after RT correction.}
}
If no adjusted retention times are available, \code{NULL} is returned.
}
\description{
Extracts raw and adjusted retention times from an xcms-processed object
when retention time correction has been performed.
}
\details{
If the object is not an xcms processed data object, or if retention time
adjustment has not been applied, the function returns \code{NULL}.
}
\keyword{internal}
