% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-adapters.R
\name{get_detected_peaks}
\alias{get_detected_peaks}
\alias{get_detected_peaks.character}
\alias{get_detected_peaks.XCMSnExp}
\alias{get_detected_peaks.MsExperiment}
\alias{get_detected_peaks.ExternalDataSource}
\title{Get the detected peaks from the data object (e.g. XCMSnExp)}
\usage{
get_detected_peaks(obj)

\method{get_detected_peaks}{character}(obj)

\method{get_detected_peaks}{XCMSnExp}(obj)

\method{get_detected_peaks}{MsExperiment}(obj)

\method{get_detected_peaks}{ExternalDataSource}(obj)
}
\arguments{
\item{obj}{A data object containing or representing samples.}
}
\value{
A \code{data.frame} of detected peaks (one row per peak), or \code{NULL} if no
peaks are available.
}
\description{
\code{get_detected_peaks()} is an internal helper that standardises extraction of
detected chromatographic peaks across different object types commonly used in
LC-MS workflows.
}
\details{
Supported inputs behave as follows:
\itemize{
\item \strong{\code{character}} – Assumed to represent sample paths; no peak detection
information is available. Always returns \code{NULL}.
\item \strong{\code{XCMSnExp}} and \strong{\code{MsExperiment}} – If the object is processed and
contains chromatographic peaks, extracts \code{xcms::chromPeaks(obj)} and
returns it as a data frame.
The column \code{sample} is renamed to \code{sample_index}.
}

When peaks are not found or the object is not processed, \code{NULL} is returned.
}
\keyword{internal}
