% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-source-compound-discoverer.R
\name{get_xic_traces_from_compounds}
\alias{get_xic_traces_from_compounds}
\title{Extract XIC traces associated with selected compounds}
\usage{
get_xic_traces_from_compounds(conn, compounds_query_str)
}
\arguments{
\item{conn}{A \code{DBIConnection} to a Compound Discoverer results database.}

\item{compounds_query_str}{A \code{character} value giving a filtering expression
evaluated on the resulting compound table (e.g. using compound name,
formula, retention time, or m/z).}
}
\value{
A \code{data.frame} containing XIC trace metadata and binary trace data
for the selected compounds.
}
\description{
Queries a Compound Discoverer results database to retrieve extracted ion
chromatogram (XIC) traces associated with consolidated compounds matching
a user-supplied filter expression.
}
\details{
The query joins multiple internal Compound Discoverer tables to link
consolidated compounds to reference ions, chromatogram peaks, and XIC
trace data.
}
\keyword{internal}
