% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-package.R
\docType{package}
\name{lcmsPlot-package}
\alias{lcmsPlot-package}
\title{lcmsPlot: Comprehensive Liquid Chromatography-Mass Spectrometry (LC-MS)
data visualisation package}
\description{
lcmsPlot offers flexible and powerful visualisation of raw and processed
LC-MS data. It supports chromatograms, mass spectra, and other plot types,
combining high performance with broad customisation.
Designed for large datasets, it facilitates assessment of signal quality,
feature comparison across samples, and generation of
publication-ready figures.
}
\details{
\strong{Main features}
\itemize{
\item Unified, intuitive, and ggplot2-like interface.
\item Plot from different types of sources, such as raw files (e.g. mzML),
XCMS objects (e.g., \code{XCMSnExp}), or Compound Discoverer results.
\item Plot chromatograms, mass traces, spectra, and more.
\item Combine different types of LC-MS data plots (e.g. chromatograms with
spectra).
\item Arrange plots in different ways according to metadata factors.
\item Large-scale plotting through iterative batching.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/computational-metabolomics/lcmsPlot}
  \item Report bugs at \url{https://github.com/computational-metabolomics/lcmsPlot/issues}
}

}
\author{
\strong{Maintainer}: Ossama Edbali \email{o.edbali@bham.ac.uk} (\href{https://orcid.org/0000-0003-0132-8668}{ORCID})

Authors:
\itemize{
  \item Ralf Johannes Maria Weber \email{r.j.weber@bham.ac.uk} (\href{https://orcid.org/0000-0002-8796-4771}{ORCID})
}

}
