% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lcmsPlot}
\alias{lcmsPlot}
\title{Create an \code{lcmsPlotClass} object}
\usage{
lcmsPlot(
  dataset,
  sample_id_column = "sample_id",
  metadata = NULL,
  batch_size = NULL,
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{dataset}{An object of type \code{XCMSnExp}, \code{MsExperiment},
\code{MZmineSource}, or \code{character}.
If a \code{character} vector is supplied, it will be interpreted as a list
of mzML paths.}

\item{sample_id_column}{A \code{character} value indicating which column
should be used as the sample ID. By default it is \code{"sample_id"}.}

\item{metadata}{A \code{data.frame} containing the samples metadata
in case it is not provided in the dataset object.}

\item{batch_size}{A \code{numeric} value indicating the number of
samples per batch. This parameter is necessary when plotting
multiple batches using the \code{iterate_plot_batches} or \code{next_plot} functions.}

\item{BPPARAM}{A \code{BiocParallelParam} object for enabling parallelism.
See \link[BiocParallel:BiocParallelParam-class]{BiocParallelParam}
for more information.}
}
\value{
An instance of \code{lcmsPlotClass}. It will create the necessary
internal structures related to the data (\code{data} slot)
and options (\code{options} slot).
}
\description{
The \code{lcmsPlotClass} class allows a unified approach for  the management
of LC-MS data for the purpose of visualisation. It includes the options
for customising the plot, the LC-MS data, and the underlying plot object.
The \code{lcmsPlot} function is the main entry point and the preferred approach
to creating \code{lcmsPlotClass} objects.
}
\examples{
raw_files <- dir(
   system.file("cdf", package = "faahKO"),
   full.names = TRUE,
   recursive = TRUE)[1:5]

p <- lcmsPlot(raw_files)
}
