% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_arrange}
\alias{lp_arrange}
\title{Define the arrangement of chromatograms}
\usage{
lp_arrange(group_by)
}
\arguments{
\item{group_by}{A \code{character} value determining the
column to group by in the samples metadata.}
}
\value{
A function that takes an \code{lcmsPlot} object and returns a modified
version with the specified arrangement options
stored in \code{options$arrangement}. It is intended for use with the \code{+}
operator, which incrementally layers new data or visual components
onto the \code{lcmsPlot} object.
}
\description{
The \code{lp_arrange} function specifies how chromatograms should be arranged
when visualised. It determines the grouping metadata factor through
the \code{group_by} parameter.
}
\examples{
raw_files <- dir(
   system.file("cdf", package = "faahKO"),
   full.names = TRUE,
   recursive = TRUE)[1:5]

## Plots chromatograms overlayed without specifying a grouping factor
p <- lcmsPlot(raw_files) +
  lp_chromatogram(aggregation_fun = "max")
p

## Plots chromatograms overlayed specifying a grouping factor
## (e.g., sample_id)
p <- p + lp_arrange(group_by = "sample_id")
p
}
