% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_chromatogram}
\alias{lp_chromatogram}
\title{Define the chromatograms to plot}
\usage{
lp_chromatogram(
  features = NULL,
  sample_ids = NULL,
  ppm = 10,
  rt_tol = 10,
  highlight_peaks = FALSE,
  highlight_peaks_color = NULL,
  highlight_peaks_factor = "sample_id",
  aggregation_fun = "max",
  rt_type = "uncorrected",
  rt_unit = "second",
  intensity_unit = "absolute",
  fill_gaps = FALSE,
  highlight_apices = list(column = NULL, top_n = NULL)
)
}
\arguments{
\item{features}{Specifies which features to generates the chromatogram for.
This can be either:
a \code{matrix} with columns \code{mz} and \code{rt} (optional);
a \code{matrix} with columns \code{mzmin}, \code{mzmax},
\code{rtmin} (optional), \code{rtmax} (optional);
a \code{data.frame} with columns \code{sample_id}, \code{mz} and \code{rt} (optional);
a \code{data.frame} with columns \code{sample_id}, \code{mzmin}, \code{mzmax},
\code{rtmin} (optional), \code{rtmax} (optional);
a \code{character} vector representing the grouped peaks (feature) names
as returned by \code{xcms::groupnames} - requires the data to be
an \code{XCMSnExp} or \code{MsExperiment} object with grouped peaks.}

\item{sample_ids}{A \code{character} vector specifying the sample IDs
to include in the plot. If \code{NULL}, the function uses the sample IDs
specified in the \code{lcmsPlot} object.}

\item{ppm}{A \code{numeric} value specifying the mass accuracy (in ppm) used
when generating chromatograms. Ignored when the \code{features} parameter
specifies both \code{mzmin} and \code{mzmax}.}

\item{rt_tol}{A \code{numeric} value specifying the RT tolerance used
when generating chromatograms. Ignored when the \code{features} parameter
specifies both \code{rtmin} and \code{rtmax}.}

\item{highlight_peaks}{A \code{logical} value indicating whether to highlight
the detected peaks; the input data must be an \code{XCMSnExp} or \code{MsExperiment}
object.}

\item{highlight_peaks_color}{A \code{character} value indicating the color of the
highlighted peaks.}

\item{highlight_peaks_factor}{A \code{character} value indicating the factor from
the metadata that determines the color. By default it colors by \code{sample_id}.}

\item{aggregation_fun}{A \code{character} value indicating which aggregation
function to use for the spectra intensities; one of \code{max} or \code{sum}.
Only applicable to summary chromatograms.}

\item{rt_type}{A \code{chracter} value indicating what type of RT to use for the
chromatograms. One of \code{uncorrected} (default), \code{corrected}, or \code{both};
the input data must be an \code{XCMSnExp} or \code{MsExperiment} object.
If \code{both} is chosen, this will give access to a metadata column called
\code{rt_adjusted} that can be used to differentiate the two RT types (e.g.,
through faceting).}

\item{rt_unit}{A \code{character} value indicating the unit to use for
the RT axis; one of \code{"minute"} or \code{"second"}.}

\item{intensity_unit}{A \code{character} value indicating the unit to use for
the intensity axis; one of \code{"absolute"} or \code{"relative"}.}

\item{fill_gaps}{A \code{logical} value indicating whether to fill gaps
in RT with 0 intensity.}

\item{highlight_apices}{A \code{logical} value indicating whether to
highlight apices with the corresponding RT values in a chromatogram.}
}
\value{
This function returns another function that takes an \code{lcmsPlot}
object and produces a modified version containing the generated chromatograms
in its \code{data} slot. It is designed to be used with the \code{+} operator,
which serves as a layering mechanism. Each use of \code{+} incrementally enriches
the \code{lcmsPlot} object by adding new data or visual components.
}
\description{
The \code{lp_chromatogram} function allows the generation of different types of
chromatograms.
}
\section{Summary chromatograms}{

In this type of chromatogram, the intensities of the spectra from each scan
in an LC–MS dataset are either summed to produce the total ion current (TIC)
chromatogram or the most intense peak is selected to produce the
base peak chromatogram (BPC).
To create such chromatograms do not specify the \code{features} parameter as
that will create the chromatograms for the selected features.
In this context, the main parameter if \code{aggregation_fun} which can take
either \code{sum} (TIC) or \code{max} (BPC).
}

\section{Feature chromatograms}{

A feature is a combination of retention time (RT) and m/z. Feature
chromatograms can be created by specifiying the \code{features} parameter.
}

\examples{
raw_files <- dir(
   system.file("cdf", package = "faahKO"),
   full.names = TRUE,
   recursive = TRUE)[1:5]

p <- lcmsPlot(raw_files) +
  lp_chromatogram(aggregation_fun = "max") +
  lp_arrange(group_by = "sample_id")

p
}
