% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_compound_discoverer}
\alias{lp_compound_discoverer}
\title{Define the options to use when plotting LC-MS data coming from
Compound Discoverer results.}
\usage{
lp_compound_discoverer(compounds_query = NULL, rt_extend = 10)
}
\arguments{
\item{compounds_query}{A \code{character} value indicating the expression
used to filter compounds from the Compound Discoverer results.
The expression is evaluated on the compound table and can reference
the following columns:
\describe{
\item{name}{Compound name.}
\item{formula}{Chemical formula of the compound.}
\item{adduct}{Ion adduct (e.g. \verb{[M+H]+}, \verb{[M-H]-}).}
\item{rt}{Retention time of the compound (in seconds).}
\item{rtmin}{Minimum retention time of the compound peak.}
\item{rtmax}{Maximum retention time of the compound peak.}
\item{mz}{Mass-to-charge ratio (m/z) of the detected ion.}
\item{maxo}{Maximum observed peak intensity.}
\item{into}{Integrated peak area reported by Compound Discoverer.}
}}

\item{rt_extend}{A \code{numeric} value indicating how much (in seconds)
the retention time window should be extended on each side of the
compound peak when extracting and plotting chromatograms.}
}
\value{
A function that takes an \code{lcmsPlot} object and returns a modified
version with the specified Compound Discoverer options stored in
\code{options$compound_discoverer}. It is intended for use with the \code{+} operator,
which incrementally layers new data or visual components onto
the \code{lcmsPlot} object.
}
\description{
Define the options to use when plotting LC-MS data coming from
Compound Discoverer results.
}
\examples{
\dontrun{
lcmsPlot("cd_example.cdResult") +
  lp_compound_discoverer(
    compounds_query = 'name \%in\% c("Proline", "Betaine")',
    rt_extend = 5
  ) +
  lp_chromatogram(highlight_peaks = TRUE) +
  lp_grid(rows = "sample_id", cols = "name", free_x = TRUE) +
  lp_labels(title = "Compound Discoverer example", legend = "Sample") +
  lp_legend(position = "bottom")
}
}
