% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_facets}
\alias{lp_facets}
\title{Define the plot's faceting}
\usage{
lp_facets(facets, ncol = NULL, nrow = NULL, free_x = FALSE, free_y = FALSE)
}
\arguments{
\item{facets}{A \code{character} vector of factors from the sample metadata to use
for faceting.}

\item{ncol}{A \code{numeric} value indicating the number of columns in the layout.}

\item{nrow}{A \code{numeric} value indicating the number of rows in the layout.}

\item{free_x}{A \code{logical} value indicating whether the x-axis scales
are allowed to vary across panels.}

\item{free_y}{A \code{logical} value indicating whether the y-axis scales
are allowed to vary across panels.}
}
\value{
A function that takes an \code{lcmsPlot} object and returns a modified
version with the specified faceting options stored in \code{options$facets}.
It is intended for use with the \code{+} operator, which incrementally layers
new data or visual components onto the \code{lcmsPlot} object.
}
\description{
The \code{lp_facets} function arranges plots into a grid based
on a metadata factor, creating a series of smaller plots (facets).
}
\examples{
raw_files <- dir(
   system.file("cdf", package = "faahKO"),
   full.names = TRUE,
   recursive = TRUE)[1:5]

## Plots chromatograms overlayed
p <- lcmsPlot(raw_files) +
  lp_chromatogram(aggregation_fun = "max")
p

## Using lp_facets we create facets for each sample_id
p <- p + lp_facets(facets = "sample_id")
p
}
