% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_get_plot}
\alias{lp_get_plot}
\title{Get the underlying plot object.}
\usage{
lp_get_plot()
}
\value{
A function that takes an \code{lcmsPlot} object and returns a modified
version with the rendered plot stored in the \code{plot} slot.
It is intended for use with the \code{+} operator, which incrementally layers
new data or visual components onto the \code{lcmsPlot} object.
}
\description{
Get the underlying plot object.
}
\examples{
raw_files <- dir(
   system.file("cdf", package = "faahKO"),
   full.names = TRUE,
   recursive = TRUE)[1:4]

## Create faceted chromatogram plots with a reference RT line
p <- lcmsPlot(raw_files) +
  lp_chromatogram(features = rbind(c(
    mzmin = 334.9,
    mzmax = 335.1,
    rtmin = 2700,
    rtmax = 2900))) +
  lp_facets(facets = 'sample_id', ncol = 4) +
  lp_rt_line(intercept = 2800, line_type = 'solid', color = 'red')
p

## Extract the ggplot object and apply a theme
p <- p +
  lp_get_plot() +
  ggplot2::theme_bw()
p
}
