% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_grid}
\alias{lp_grid}
\title{Define a gridded plot}
\usage{
lp_grid(rows, cols, free_x = FALSE, free_y = FALSE)
}
\arguments{
\item{rows}{A \code{character} value indicating the factors that
represent rows.}

\item{cols}{A \code{character} value indicating the factors that
represent columns.}

\item{free_x}{A \code{logical} value indicating whether the x-axis scales
are allowed to vary across panels.}

\item{free_y}{A \code{logical} value indicating whether the y-axis scales
are allowed to vary across panels.}
}
\value{
A function that takes an \code{lcmsPlot} object and returns a modified
version with the specified grid options stored in \code{options$grid}.
It is intended for use with the \code{+} operator, which incrementally layers
new data or visual components onto the \code{lcmsPlot} object.
}
\description{
The \code{lp_grid} function arranges plots into a matrix of panels defined
by row and column faceting metadata factors.
}
\examples{
raw_files <- dir(
  system.file("cdf", package = "faahKO"),
  full.names = TRUE,
  recursive = TRUE
)[1:4]

## Create metadata for the samples
metadata <- data.frame(
  sample_id = sub("\\\\.CDF", "", basename(raw_files)),
  factor1 = c("S", "S", "C", "C"),
  factor2 = c("T", "U", "T", "U")
)

## Create feature chromatograms for the specified samples
p <- lcmsPlot(raw_files, metadata = metadata) +
  lp_chromatogram(features = rbind(c(
    mzmin = 334.9,
    mzmax = 335.1,
    rtmin = 2700,
    rtmax = 2900)))
p

## Arrange chromatograms in a grid split by experimental factors
## Rows correspond to `factor1` and columns correspond to `factor2`
p <- p + lp_grid(rows = "factor1", cols = "factor2")
p
}
