% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_intensity_map}
\alias{lp_intensity_map}
\title{Define a 2D intensity map}
\usage{
lp_intensity_map(mz_range, rt_range, sample_ids = NULL, density = FALSE)
}
\arguments{
\item{mz_range}{A \code{numeric} value indicating the m/z range of the map.}

\item{rt_range}{A \code{numeric} value indicating the RT range of the map.}

\item{sample_ids}{A \code{character} vector specifying the sample IDs
to include in the plot. If \code{NULL}, the function uses the sample IDs
specified in the \code{lcmsPlot} object.}

\item{density}{A \code{logical} value indicating whether to show a density plot.}
}
\value{
This function returns another function that takes an
\code{lcmsPlot} object and produces a modified version containing the generated
2D intensity map in its \code{data} slot. It is designed to be used with the
\code{+} operator, which serves as a layering mechanism.
Each use of \code{+} incrementally enriches the \code{lcmsPlot} object by
adding new data or visual components.
}
\description{
The \code{lp_intensity_map} function produces an intensity map
in which retention time is shown on the x-axis, m/z on the y-axis,
and signal intensity is represented at each corresponding coordinate.
}
\examples{
raw_files <- dir(
  system.file("cdf", package = "faahKO"),
  full.names = TRUE,
  recursive = TRUE)[1]

p <- lcmsPlot(raw_files) +
  lp_intensity_map(
    mz_range = c(200, 600),
    rt_range = c(4200, 4500),
    density = TRUE)
p
}
