% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_labels}
\alias{lp_labels}
\title{Define the labels of the plot}
\usage{
lp_labels(title = NULL, legend = NULL)
}
\arguments{
\item{title}{A \code{character} value indicating the plot title.}

\item{legend}{A \code{character} value indicating the legend's title.}
}
\value{
A function that takes an \code{lcmsPlot} object and returns a modified
version with the specified label options stored in \code{options$labels}.
It is intended for use with the \code{+} operator, which incrementally layers
new data or visual components onto the \code{lcmsPlot} object.
}
\description{
The \code{lp_labels} function allows the specification
of the plot title and the legend title.
}
\examples{
raw_files <- dir(
   system.file("cdf", package = "faahKO"),
   full.names = TRUE,
   recursive = TRUE)[1:5]

## Create a chromatogram plot by grouping samples into batches
## By default, the legend is derived from the grouping variable
p <- lcmsPlot(raw_files, batch_size = 2) +
  lp_chromatogram(features = rbind(c(
    mzmin = 334.9,
    mzmax = 335.1,
    rtmin = 2700,
    rtmax = 2900))) +
  lp_arrange(group_by = "sample_id")
p

## Customise the legend label
p <- p + lp_labels(legend = "Sample")
p
}
