% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_legend}
\alias{lp_legend}
\title{Define the legend layout}
\usage{
lp_legend(position = NULL)
}
\arguments{
\item{position}{A \code{character} value indicating the legend's position.
One of \code{"top"}, \code{"right"}, \code{"bottom"}, \code{"left"}, or \code{"inside"}.}
}
\value{
A function that takes an \code{lcmsPlot} object and returns a modified
version with the specified legend options stored in \code{options$legend}.
It is intended for use with the \code{+} operator, which incrementally layers
new data or visual components onto the \code{lcmsPlot} object.
}
\description{
Define the legend layout
}
\examples{
raw_files <- dir(
   system.file("cdf", package = "faahKO"),
   full.names = TRUE,
   recursive = TRUE)[1:5]

## Create a chromatogram plot grouped by sample with a custom legend label
p <- lcmsPlot(raw_files, batch_size = 2) +
  lp_chromatogram(features = rbind(c(
    mzmin = 334.9,
    mzmax = 335.1,
    rtmin = 2700,
    rtmax = 2900))) +
  lp_arrange(group_by = "sample_id") +
  lp_labels(legend = "Sample")
p

## Move the legend below the plot
p <- p + lp_legend(position = "bottom")
p
}
