% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_mass_trace}
\alias{lp_mass_trace}
\title{Define the mass trace to plot}
\usage{
lp_mass_trace()
}
\value{
This function returns another function that takes an \code{lcmsPlot}
object and produces a modified version containing the generated mass traces
in its \code{data} slot. It is designed to be used with the \code{+} operator,
which serves as a layering mechanism. Each use of \code{+} incrementally enriches
the \code{lcmsPlot} object by adding new data or visual components.
}
\description{
The \code{lp_mass_trace} function enables the generation of mass traces,
which are graphical representations commonly used in mass spectrometry
data analysis. A mass trace plots individual data points defined by their
retention time and corresponding mass-to-charge ratio (m/z), making it easier
to visualise how specific ions behave over the course of a
chromatographic run.
}
\examples{
raw_files <- dir(
   system.file("cdf", package = "faahKO"),
   full.names = TRUE,
   recursive = TRUE)[1:5]

## Create chromatograms of a specific feature
p <- lcmsPlot(raw_files) +
  lp_chromatogram(features = rbind(c(
    mzmin = 334.9,
    mzmax = 335.1,
    rtmin = 2700,
    rtmax = 2900))) +
  lp_arrange(group_by = "sample_id")

## Add mass traces
p <- p + lp_mass_trace()

p
}
