% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcmsPlot-class.R
\name{lp_rt_diff_plot}
\alias{lp_rt_diff_plot}
\title{Generate the retention time difference plot between raw and adjusted datasets}
\usage{
lp_rt_diff_plot()
}
\value{
This function returns another function that takes an
\code{lcmsPlot} object and produces a modified version containing the generated
retention time differences, between raw and adjusted,  in its \code{data} slot.
It is designed to be used with the \code{+} operator, which serves as a layering
mechanism. Each use of \code{+} incrementally enriches the \code{lcmsPlot} object by
adding new data or visual components.
}
\description{
The \code{lp_rt_diff_plot} function generates the data necessary to plot
the difference between the raw and retention time adjusted datasets.
Only applicable to \code{XCMSnExp} and \code{MsExperiment} objects.
}
\examples{
data_obj <- get_XCMSnExp_object_example(
  indices = 1:3,
  should_group_peaks = TRUE)
p <- lcmsPlot(data_obj, sample_id_column = "sample_name") +
  lp_rt_diff_plot()
p
}
